REM  Copyright (c) 1998 by Oracle Corporation 
REM    NAME
REM     MAPISolutionDemo.sql - Make use of APIs exposed by MAPISolution.sql
REM    DESCRIPTION
REM		Gives a little demonstration on using the Oracle COM callouts capabilities of
REM		Oracle. Connects to the scott/tiger database and extracts the data and send an email
REM		to a specified recipient
REM
REM    MODIFIED   (MM/DD/YY)
REM     kfleong	   02/10/98 -  Creation
REM	klau	   06/01/99 -  Change to reflect updated API for sending email
REM
REM	


set serveroutput on;
declare 
	i binary_integer;
	message varchar2(2048);
	recipient varchar2(128);
begin

i:=ORDMapi.CreateMAPISession;
i:=ORDMapi.NewMessage;

/* Replace scott@us.oracle.com with your email address */
i:=ORDMapi.AddRecipient('scott@us.oracle.com');

i:=ORDMapi.SetSubject('MAPI Solution Demo Email');

message:='Your database currently contains employees ';

i := 0;
for row in (select * from emp) loop
	if (i = 0) then
		message := message || row.ENAME;
	else
		message := message || ', ' || row.ENAME;
	end if;
	i := i + 1;
end loop;

message:=message || '. This message is automatically generated and send to you from an Oracle8i database via the COM cartridge using DCOM.';
i:=ORDMapi.SetBody (message);

i:=ORDMapi.SendMessage;
i:=ORDMapi.EndMAPISession;

end;
/